<?php

namespace App\Http\Controllers\Admin;

use App\Helper\Helpers;
use App\Http\Controllers\Controller;
use App\Models\ForgotPassword;
use App\Models\Role;
use App\Models\RoleUser;
use App\Models\Operator;
use Illuminate\Http\Request;
use Hash;

class UserController extends Controller
{
    public function index(){
        return view('admin.user.index');
     }

    

    // Register
    public function register(Request $request)
    {
         $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:billing_users,email',
            'phone' => 'required',
            'password' => 'min:6|required_with:password_confirmation|same:password_confirmation',
            'password_confirmation' => 'min:6'
         ]);
         $register= new User();
         $register->name = $request->name;
         $register->email = $request->email;
         $register->phone = $request->phone;
         if(!empty($request->dob)){
             $register->dob = date('Y-m-d',strtotime($request->dob));
         }
         $register->password = Hash::make($request->password);
         $register->save();
         $request->session()->put(["login_user"=> $register]);
         return redirect('dashboard');
    }  
    // End Register


    // Login
    public function login(Request $request)
    {
       $request->validate([
           'username' => 'required',
           'password' => 'required',
       ]);

       $location_name = (!empty($request->location)) ? $request->location : "default";    


       $register = Operator::where('username', $request->username)->first();

       if(!empty($register) && !$request->password == $register->password){
           return redirect()->back()->with('status','Please enter vaild password..!');
       }

       if(!empty($register))
       {
          $request->session()->put(["login_user"=> $register]);
          return redirect('dashboard');
       }else{
           return redirect()->back()->with('status','User Not Found');
       }
    }
    // End Login




    // Forgot Password
    public function forgot_password(Request $request){
        $request->validate([
            'email' => 'required|email',
        ]);
        $user = User::where('email', $request->email)->first();
        if(empty($user)){
            return redirect()->back()->with('status','Enter a valid email');
        }

        $forgot_password = new ForgotPassword();
        $forgot_password->user_id = $user->id;
        $forgot_password->token = Helpers::genrateToken(10);
        $forgot_password->save();

        return redirect('email-verification');
    }

    public function email_verification(Request $request){
        $request->validate([
            'token' => 'required',
            'password' => 'min:6|required_with:password_confirmation|same:password_confirmation',
            'password_confirmation' => 'min:6'
        ],[
            'token.required'=>'The verification code field is required.'
        ]);

        $forgot_password = ForgotPassword::where('token', $request->token)->first();

       if(empty($forgot_password)){
           return redirect()->back()->with('status','Please enter vaild verification code..!');
       }else{
           $user= User::find($forgot_password->user_id	);
           $user->password = Hash::make($request->password);
           $user->save();
           $forgot_password->delete();
           return redirect('login');
       }
       return redirect()->back()->with('status','server issue..!');
    }
    // End Forgot Password


    // Logout
    public function logout(Request $request)
    {
        $request->session()->forget('login_user');
        return redirect('/');
    }
    // End Logout



    // Role Management
    public function role(){
        $roles = Role::all();
        return view('admin.role.index',compact('roles'));
    }
    public function add_role(){
        return view('admin.role.add');
    }
    public function save_role(Request $request){
        $request->validate([
            'name' => 'required|unique:billing_role,name',
        ]);
        $roles = new Role;
        $roles->name=$request->name;
        $roles->description=$request->description;
        $roles->save();
        $request->session()->flash('success_msg','Role Cerated Successfully..!');
        return redirect('role');
    }
    public function edit_role($id)
    {
        $role = Role::find($id);
        return view('admin.role.edit',compact('role'));
    }
    public function update_role(Request $request){
        $request->validate([
            'name' => 'required|unique:billing_role,name,'.$request->role_id,
        ]);
        $roles = Role::find($request->role_id);
        $roles->name=$request->name;
        $roles->description=$request->description;
        $roles->save();
        $request->session()->flash('success_msg','Role Updated Successfully..!');
        return redirect('role');
    }
    public function delete_role(Request $request,$id){
        Role::find($id)->delete();
        RoleUser::where('role_id',$id)->delete();
        $request->session()->flash('success_msg','Role Deleted Successfully..!');
        return back();
    }
    // End Role management



    // User Management
    public function user(){
        $users = User::with('roles')->get();
        return view('admin.user.index',compact('users'));
    }
    public function add_user(){
        $roles = Role::all();
        return view('admin.user.add',compact('roles'));
    }
    public function save_user(Request $request){
        $request->validate([
            'name' => 'required',
            'role_id' => 'required',
            'email' => 'required|unique:billing_users,email',
            'password' => 'min:6|required_with:password_confirmation|same:password_confirmation',
            'password_confirmation' => 'min:6'
        ],[
            'role_id.required'=>'The user role field is required.'
        ]);
        $users = new User;
        $users->name=$request->name;
        $users->phone=$request->phone;
        $users->email=$request->email;
        if(!empty($request->dob)){
            $users->dob = date('Y-m-d',strtotime($request->dob));
        }
        $users->password = Hash::make($request->password);
        $users->save();

        $role_users = new RoleUser();
        $role_users->user_id=$users->id;
        $role_users->role_id=$request->role_id;
        $role_users->save();
        
        $request->session()->flash('success_msg','User Cerated Successfully..!');
        return redirect('user');
    }
    public function edit_user($id)
    {
        $user = User::with('roles')->find($id);
        $roles = Role::all();
        return view('admin.user.edit',compact('user','roles'));
    }
    public function update_user(Request $request){
        $request->validate([
            'name' => 'required',
            'role_id' => 'required',
            'email' => 'required|unique:billing_users,email,'.$request->user_id,
        ],[
            'role_id.required'=>'The user role field is required.'
        ]);
        $users = User::find($request->user_id);
        $users->name=$request->name;
        $users->phone=$request->phone;
        $users->email=$request->email;
        if(!empty($request->dob)){
            $users->dob = date('Y-m-d',strtotime($request->dob));
        }
        $users->save();

        $role_users = RoleUser::where('user_id',$request->user_id)->first();
        if(empty($role_users)){
            $role_users = new RoleUser();
            $role_users->user_id=$users->id;
        }
        $role_users->role_id=$request->role_id;
        $role_users->save();

        $request->session()->flash('success_msg','User Updated Successfully..!');
        return redirect('user');
    }
    public function delete_user(Request $request,$id){

        
        User::find($id)->delete();
        RoleUser::where('user_id',$id)->delete();
        $request->session()->flash('success_msg','User Deleted Successfully..!');
        return back();
    }
    // End User management
}
