@extends('layouts.app')
@section('css')
    {{-- css --}}
    <link href="{{ url('public/assets/vendors/datatables.net-bs4/css/dataTables.bootstrap4.css') }}" rel="stylesheet">
    <style>
        div.dataTables_wrapper div.dataTables_length select {
            width: 60px
        }

        #DataTables_Table_0_wrapper .col-sm-12 {
            overflow: auto;
        }
    </style>
@endsection
@section('title', 'Partner Management')
@section('breadcrumb')
    <ol class="breadcrumb border-0 m-0 px-0 px-md-3">
        <li class="breadcrumb-item">Home</li>
        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Admin</a></li>
        <li class="breadcrumb-item active">Partner Management</li>
    </ol>
@endsection
@section('content')
    <div class="card">
        <div class="card-header"> Partner Management
            <div class="card-header-actions">
                <a href="{{ route('admin.add.partner') }}" class="btn btn-square btn-block btn-info">+ Create Partner</a>
            </div>
        </div>
        <div class="card-body">
            @if (Session::has('success_msg'))
                <div class="alert alert-success" role="alert">{{ Session::get('success_msg') }}</div>
            @endif
            @if (Session::has('error_msg'))
                <div class="alert alert-danger" role="alert">{{ Session::get('error_msg') }}</div>
            @endif
            <table class="table table-striped table-bordered datatable">
                <thead>
                    <tr>
                        <th>Partner Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Partner Name</td>
                        <td>Email</td>
                        <td>Phone</td>
                        <td>
                            <button class="btn btn-info mr-1" data-toggle="modal" data-target="#largeModal">
                                <img class="c-icon" src="{{ url('public/assets/vendors/@coreui/icons/svg/eye.svg') }}">
                            </button>
                            <a class="btn btn-info mr-1" href="{{ route('admin.edit.partner', 1) }}">
                                <svg class="c-icon">
                                    <use
                                        xlink:href="{{ url('public/assets/vendors/@coreui/icons/svg/free.svg#cil-pencil') }}">
                                    </use>
                                </svg>
                            </a>
                            <a class="btn btn-danger mr-1" href="{{ route('admin.delete.partner', 1) }}"
                                onclick="return confirm('Are you sure you want to delete this partner?');">
                                <svg class="c-icon">
                                    <use
                                        xlink:href="{{ url('public/assets/vendors/@coreui/icons/svg/free.svg#cil-trash') }}">
                                    </use>
                                </svg>
                            </a>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.modal-->
    <div class="modal fade" id="largeModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Partner Detail</h4>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">×</span></button>
                </div>
                <div class="modal-body">
                    <table width="100%">
                        <tbody width="100%">

                            <tr >
                                <td colspan="6" class="pt-1 bg-secondary" ><h4 class="text-center w-100 text-muted"> Partner Basic Details </h4><td>
                            </tr>

                            <tr>
                                <th><b>Partner Name</b></th>
                                <td><b> : </b></td>
                                <td>Romit B. Maniya</td>

                                <th><b>Email</b></th>
                                <td><b> : </b></td>
                                <td>romitmaniya2@gmail.com</td>
                            </tr>
                            <tr>
                                <th><b>phone</b></th>
                                <td><b> : </b></td>
                                <td>+91 7285051097</td>
                            </tr>
                            
                       

                            <tr >
                                <td colspan="6" class="pt-1 bg-secondary" ><h4 class="text-center w-100 text-muted"> Address </h4><td>
                            </tr>

                  
                            <tr>
                                <th><b>Country Code</b></th>
                                <td><b> : </b></td>
                                <td>IN</td>
                                
                                <th><b>Post Code</b></th>
                                <td><b> : </b></td>
                                <td>394101</td>
                            </tr>
                            <tr>
                                <th><b>City</b></th>
                                <td><b> : </b></td>
                                <td>Surat</td>

                                <th><b>Address</b></th>
                                <td><b> : </b></td>
                                <td>Mota Varachha, surat</td>
                            </tr>


                            <tr >
                                <td colspan="6" class="pt-1 bg-secondary" ><h4 class="text-center w-100 text-muted"> Bank Detail  </h4><td>
                            </tr>

                           
                            <tr>
                                <th><b>Account Number</b></th>
                                <td><b> : </b></td>
                                <td>7896924553258632</td> 

                                <th><b>Swift Code</b></th>
                                <td><b> : </b></td>
                                <td>BOBDEF</td>
                            </tr>
                            <tr>
                                <th><b>Iban</b></th>
                                <td><b> : </b></td>
                                <td>ferer545e14562</td>

                                <th><b>General Ledger No.</b></th>
                                <td><b> : </b></td>
                                <td>zg241dsfv4t</td>
                            </tr>
                            <tr>
                                <th><b>Tax Code</b></th>
                                <td><b> : </b></td>
                                <td>fvdbt4ert2et5</td>
                                
                                <th><b>Tax Type</b></th>
                                <td><b> : </b></td>
                                <td>Percentage</td>
                            </tr>
                            <tr>
                                <th><b>Group Member Tax No.</b></th>
                                <td><b> : </b></td>
                                <td>fvdbt4ert2et5</td>
                            </tr>
                            

                            <tr >
                                <td colspan="6" class="pt-1 bg-secondary" ><h4 class="text-center w-100 text-muted"> Custom Billing Settings  </h4><td>
                            </tr>

                            <tr>
                                <th><b>Payment Method</b></th>
                                <td><b> : </b></td>
                                <td>aruhitel</td> 

                                <th><b>Document Form</b></th>
                                <td><b> : </b></td>
                                <td>electronic</td>
                            </tr>
                            <tr>
                                <th><b>Due Days</b></th>
                                <td><b> : </b></td>
                                <td>0</td>

                                <th><b>Document Currency</b></th>
                                <td><b> : </b></td>
                                <td>AUD</td>
                            </tr>
                            <tr>
                                <th><b>Template Language Code</b></th>
                                <td><b> : </b></td>
                                <td>de</td>
                                
                            </tr>
                            <tr>
                                <th><b>Discount Type</b></th>
                                <td><b> : </b></td>
                                <td>percent</td>
                                
                                <th><b>Discount Value</b></th>
                                <td><b> : </b></td>
                                <td>0</td>
                            </tr>

                        </tbody>
                    </table>
                    
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                </div>
            </div>
            <!-- /.modal-content-->
        </div>
        <!-- /.modal-dialog-->
    </div>
    <!-- /.modal-->
@endsection

@section('js')
    {{-- js --}}
    <script src="{{ url('public/assets/vendors/jquery/js/jquery.slim.min.js') }}"></script>
    <script src="{{ url('public/assets/vendors/datatables.net/js/jquery.dataTables.js') }}"></script>
    <script src="{{ url('public/assets/vendors/datatables.net-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ url('public/assets/js/datatables.js') }}"></script>
    {{-- End js --}}
@endsection
