@extends('layouts.app')
@section('title', 'Spendings Management')
@section('breadcrumb')
    <ol class="breadcrumb border-0 m-0 px-0 px-md-3">
        <li class="breadcrumb-item">Home</li>
        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Admin</a></li>
        <li class="breadcrumb-item"><a href="{{ route('admin.spendings') }}">Spendings Management</a></li>
        <li class="breadcrumb-item active">Add Spendings</li>
    </ol>
@endsection
@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">Add Spendings</div>
                <form class="form-horizontal" action="{{ route('admin.spendings.save') }}" method="post">
                    @csrf
                    <div class="card-body">

                        <div class="form-group row">
                            <div class="form-group col-sm-3">
                                <label for="nf-email">Spendings Category</label>
                                <input class="form-control" type="text" name="category" placeholder="Enter category.."
                                    value="{{ old('category') }}">
                                <span class="text-danger">
                                    @error('category')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-9">
                                <label for="nf-email">Spendings Comment</label>
                                <input class="form-control" type="text" name="comment" placeholder="Enter comment.."
                                    value="{{ old('comment') }}">
                                <span class="text-danger">
                                    @error('comment')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Currency</label>
                                <select class="form-control" name="currency" >
                                    <option value="">--Select Currency--</option>
                                    <option value="AUD">AUD</option>
                                    <option value="INR">INR</option>
                                </select>
                                <span class="text-danger">
                                    @error('currency')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Conversion Rate</label>
                                <input class="form-control" type="number" name="conversion_rate" placeholder="Enter conversion rate.."
                                    value="{{ old('conversion_rate') }}">
                                <span class="text-danger">
                                    @error('conversion_rate')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>

                            <div class="form-group col-sm-2">
                                <label for="nf-email">Total Gross</label>
                                <input class="form-control" type="number" name="total_gross" placeholder="Enter total gross.."
                                    value="{{ old('total_gross') }}">
                                <span class="text-danger">
                                    @error('total_gross')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Total Gross HUF</label>
                                <input class="form-control" type="number" name="total_gross_huf" placeholder="Enter total gross huf.."
                                    value="{{ old('total_gross_huf') }}">
                                <span class="text-danger">
                                    @error('total_gross_huf')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Total Vat Amount</label>
                                <input class="form-control" type="number" name="total_vat_amount" placeholder="Enter total vat amount.."
                                    value="{{ old('total_vat_amount') }}">
                                <span class="text-danger">
                                    @error('total_vat_amount')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Total Vat Amount HUF</label>
                                <input class="form-control" type="number" name="total_vat_amount_huf" placeholder="Enter total vat amount huf.."
                                    value="{{ old('total_vat_amount_huf') }}">
                                <span class="text-danger">
                                    @error('total_vat_amount_huf')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Fulfillment Date</label>
                                <input class="form-control" type="date" name="fulfillment_date" 
                                    value="{{ old('fulfillment_date') }}">
                                <span class="text-danger">
                                    @error('fulfillment_date')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Paid at</label>
                                <input class="form-control" type="date" name="paid_at" 
                                    value="{{ old('paid_at') }}">
                                <span class="text-danger">
                                    @error('paid_at')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="nf-email">Invoice Number</label>
                                <input class="form-control" type="number" name="invoice_number" placeholder="Enter invoice number.."
                                    value="{{ old('invoice_number') }}">
                                <span class="text-danger">
                                    @error('invoice_number')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Invoice Date</label>
                                <input class="form-control" type="date" name="invoice_date" 
                                    value="{{ old('invoice_date') }}">
                                <span class="text-danger">
                                    @error('invoice_date')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Due Date</label>
                                <input class="form-control" type="date" name="due_date" 
                                    value="{{ old('due_date') }}">
                                <span class="text-danger">
                                    @error('due_date')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                          
                            <div class="form-group col-sm-4">
                                <label for="nf-email">Payment Method</label>
                                <input class="form-control" type="text" name="payment_method" placeholder="Enter payment method.."
                                    value="{{ old('payment_method') }}">
                                <span class="text-danger">
                                    @error('payment_method')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-3">
                                <label for="nf-email">Partner</label>
                                <select class="form-control" name="partner_id" >
                                    <option value="">--Select Partner--</option>
                                    <option value="0">ABC</option>
                                    <option value="1">XYZ</option>
                                </select>
                                <span class="text-danger">
                                    @error('partner_id')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button class="btn btn-sm btn-primary" type="submit"> Save</button>
                        <button class="btn btn-sm btn-danger" type="reset"> Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
