@extends('layouts.app')
@section('css')
    {{-- css --}}
    <link href="{{ url('public/assets/vendors/datatables.net-bs4/css/dataTables.bootstrap4.css') }}" rel="stylesheet">
    <style>
        div.dataTables_wrapper div.dataTables_length select { width: 60px }
        #DataTables_Table_0_wrapper .col-sm-12 { overflow: auto; }
    </style>
@endsection
@section('title', 'User Management')
@section('breadcrumb')
    <ol class="breadcrumb border-0 m-0 px-0 px-md-3">
        <li class="breadcrumb-item">Home</li>
        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Admin</a></li>
        <li class="breadcrumb-item active">User Management</li>
    </ol>
@endsection
@section('content')
    <div class="card">
        <div class="card-header"> User Management
            <div class="card-header-actions">
                <a href="{{ route('admin.add.user') }}" class="btn btn-square btn-block btn-info">+ Create User</a>
            </div>
        </div>
        <div class="card-body">
            @if(Session::has('success_msg')) <div class="alert alert-success" role="alert">{{ Session::get('success_msg') }}</div> @endif
            @if(Session::has('error_msg')) <div class="alert alert-danger" role="alert">{{ Session::get('error_msg') }}</div> @endif
            <table class="table table-striped table-bordered datatable">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>phone</th>
                        <th>email</th>
                        <th>D.O.B.</th>
                        <th>Role</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($users as $key => $val )
                        <tr>
                            <td>{{ $val->name }}</td>
                            <td>{{ $val->phone }}</td>
                            <td>{{ $val->email  }}</td>
                            <td>{{ date('d M Y', strtotime($val->dob)) }}</td>
                            <td>{{ $val->roles[0]->name ?? ''  }}</td>
                            <td>
                                <a class="btn btn-info mr-1" href="{{ route('admin.edit.user',$val->id) }}">
                                    <svg class="c-icon">
                                        <use xlink:href="{{ url('public/assets/vendors/@coreui/icons/svg/free.svg#cil-pencil') }}"></use>
                                    </svg>
                                </a>
                                <a class="btn btn-danger mr-1" href="{{ route('admin.delete.user',$val->id) }}" onclick="return confirm('Are you sure you want to delete this user?');">
                                    <svg class="c-icon">
                                        <use xlink:href="{{ url('public/assets/vendors/@coreui/icons/svg/free.svg#cil-trash') }}"></use>
                                    </svg>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection

@section('js')
    {{-- js --}}
    <script src="{{ url('public/assets/vendors/jquery/js/jquery.slim.min.js') }}"></script>
    <script src="{{ url('public/assets/vendors/datatables.net/js/jquery.dataTables.js') }}"></script>
    <script src="{{ url('public/assets/vendors/datatables.net-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ url('public/assets/js/datatables.js') }}"></script>
    {{--End js --}}
@endsection
