<?php

namespace App\Http\Controllers\Admin;

use App\Helper\Helpers;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    // Product Management
    public function product(){
        return view('admin.product.index');
    }
    public function add_product(){
        // $currencyList = Helpers::getCurrency();
        // dd($currencyList);
        return view('admin.product.add');
    }
    public function save_product(Request $request){
        $request->validate([
            'name' => 'required',
            'role_id' => 'required',
            'email' => 'required|unique:billing_products,email',
            'password' => 'min:6|required_with:password_confirmation|same:password_confirmation',
            'password_confirmation' => 'min:6'
        ],[
            'role_id.required'=>'The product role field is required.'
        ]);
        
        $request->session()->flash('success_msg','User Cerated Successfully..!');
        return redirect('product');
    }
    public function edit_product($id)
    {
        return view('admin.product.edit');
    }
    public function update_product(Request $request){
        $request->validate([
            'name' => 'required',
            'role_id' => 'required',
            'email' => 'required|unique:billing_products,email,'.$request->product_id,
        ],[
            'role_id.required'=>'The product role field is required.'
        ]);
        
        $request->session()->flash('success_msg','User Updated Successfully..!');
        return redirect('product');
    }
    public function delete_product(Request $request,$id){
        $request->session()->flash('success_msg','User Deleted Successfully..!');
        return back();
    }
    // End Product Management
}
