@extends('layouts.app')
@section('title', 'Bank Account')
@section('breadcrumb')
    <ol class="breadcrumb border-0 m-0 px-0 px-md-3">
        <li class="breadcrumb-item">Home</li>
        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Admin</a></li>
        <li class="breadcrumb-item">Setting</li>
        <li class="breadcrumb-item"><a href="{{ route('admin.bank.account') }}">Bank Account</a></li>
        <li class="breadcrumb-item active">Add Bank Account</li>
    </ol>
@endsection
@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">Add Bank Account</div>
                <form class="form-horizontal" action="{{ route('admin.role.save') }}" method="post">
                    @csrf
                    <div class="card-body">

                        <div class="form-group row">
                            <div class="form-group col-sm-6">
                                <label for="nf-email">Bank Name</label>
                                <input class="form-control" type="text" name="name" placeholder="Enter name.."
                                    value="{{ old('name') }}">
                                <span class="text-danger">
                                    @error('name')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-6">
                                <label for="nf-email">Account Number</label>
                                <input class="form-control" type="text" name="account_number" placeholder="Enter account number.."
                                    value="{{ old('account_number') }}">
                                <span class="text-danger">
                                    @error('account_number')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="nf-email">Account Number Iban</label>
                                <input class="form-control" type="text" name="account_number_iban" placeholder="Enter account number iban.."
                                    value="{{ old('account_number_iban') }}">
                                <span class="text-danger">
                                    @error('account_number_iban')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="nf-email">Swift Code</label>
                                <input class="form-control" type="text" name="swift" placeholder="Enter swift code.."
                                    value="{{ old('swift') }}">
                                <span class="text-danger">
                                    @error('swift')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="nf-email">Currency</label>
                                <select class="form-control" name="currency" >
                                    <option value="">--Select Currency--</option>
                                    <option value="AUD">AUD</option>
                                    <option value="INR">INR</option>
                                    {{-- @foreach ($currencyList as $key => $val )
                                        <option value="{{$val->from_currency}}" @if(old('currency')==$val->from_currency) selected @endif>{{$val->to_currency}}</option>
                                    @endforeach --}}
                                </select>
                                <span class="text-danger">
                                    @error('currency')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            
                        </div>
                    </div>
                    <div class="card-footer">
                        <button class="btn btn-sm btn-primary" type="submit"> Save</button>
                        <button class="btn btn-sm btn-danger" type="reset"> Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
