@extends('layouts.app')
@section('title', 'Partner Management')
@section('breadcrumb')
    <ol class="breadcrumb border-0 m-0 px-0 px-md-3">
        <li class="breadcrumb-item">Home</li>
        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Admin</a></li>
        <li class="breadcrumb-item"><a href="{{ route('admin.partner') }}">Partner Management</a></li>
        <li class="breadcrumb-item active">Edit Partner</li>
    </ol>
@endsection
@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <form class="form-horizontal" action="{{ route('admin.partner.update') }}" method="post">
                    @csrf
                    <div class="card-header">Partner Basic Details</div>
                    <div class="card-body">

                        <div class="form-group row">
                            <div class="form-group col-sm-4">
                                <label for="nf-email">Partner Name</label>
                                <input class="form-control" type="text" name="name" placeholder="Enter name.."
                                    value="{{ old('name') }}">
                                <span class="text-danger">
                                    @error('name')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="nf-email">Email</label>
                                <input class="form-control" type="text" name="email" placeholder="Enter email.."
                                    value="{{ old('email') }}">
                                <span class="text-danger">
                                    @error('email')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="nf-email">Phone</label>
                                <input class="form-control" type="text" name="phone" placeholder="Enter phone.."
                                    value="{{ old('phone') }}">
                                <span class="text-danger">
                                    @error('phone')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Country Code</label>
                                <select class="form-control" name="country_code" >
                                    <option value="">--Select Country--</option>
                                    <option value="IN">IN</option>
                                    <option value="US">US</option>
                                    <option value="NL">NL</option>
                                </select>
                                <span class="text-danger">
                                    @error('country_code')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Post Code</label>
                                <input class="form-control" type="text" name="post_code" placeholder="Enter post code.." value="{{ old('post_code') }}">
                                <span class="text-danger">
                                    @error('post_code')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">City</label>
                                <input class="form-control" type="text" name="city" placeholder="Enter city.." value="{{ old('city') }}">
                                <span class="text-danger">
                                    @error('city')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-6">
                                <label for="nf-email">Address</label>
                                <input class="form-control" type="text" name="address" placeholder="Enter address.." value="{{ old('address') }}">
                                <span class="text-danger">
                                    @error('address')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="card-header">Partner Bank Detail</div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="form-group col-sm-5">
                                <label for="nf-email">Account Number</label>
                                <input class="form-control" type="text" name="account_number" placeholder="Enter account number.."
                                    value="{{ old('account_number') }}">
                                <span class="text-danger">
                                    @error('account_number')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-3">
                                <label for="nf-email">Swift Code</label>
                                <input class="form-control" type="text" name="swift" placeholder="Enter swift.."
                                    value="{{ old('swift') }}">
                                <span class="text-danger">
                                    @error('swift')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="nf-email">Iban</label>
                                <input class="form-control" type="text" name="iban" placeholder="Enter iban.."
                                    value="{{ old('iban') }}">
                                <span class="text-danger">
                                    @error('iban')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="nf-email">General Ledger No.</label>
                                <input class="form-control" type="text" name="general_ledger_number" placeholder="Enter general ledger number.." value="{{ old('general_ledger_number') }}">
                                <span class="text-danger">
                                    @error('general_ledger_number')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="nf-email">Group Member Tax No.</label>
                                <input class="form-control" type="text" name="group_member_tax_number" placeholder="Enter group member tax number.." value="{{ old('group_member_tax_number') }}">
                                <span class="text-danger">
                                    @error('group_member_tax_number')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Tax Code</label>
                                <input class="form-control" type="text" name="taxcode" placeholder="Enter taxcode.." value="{{ old('taxcode') }}">
                                <span class="text-danger">
                                    @error('taxcode')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Tax Type</label>
                                <input class="form-control" type="text" name="tax_type" placeholder="Enter tax type.." value="{{ old('tax_type') }}">
                                <span class="text-danger">
                                    @error('tax_type')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="card-header">Custom Billing Settings</div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="form-group col-sm-4">
                                <label for="nf-email">Payment Method</label>
                                <input class="form-control" type="text" name="payment_method" placeholder="Enter payment method.."
                                    value="{{ old('payment_method') }}">
                                <span class="text-danger">
                                    @error('payment_method')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-3">
                                <label for="nf-email">Document Form</label>
                                <input class="form-control" type="text" name="document_form" placeholder="Enter document form.."
                                    value="{{ old('document_form') }}">
                                <span class="text-danger">
                                    @error('document_form')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Due Days</label>
                                <input class="form-control" type="text" name="due_days" placeholder="Enter due days.."
                                    value="{{ old('due_days') }}">
                                <span class="text-danger">
                                    @error('due_days')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-3">
                                <label for="nf-email">Document Currency</label>
                                <select class="form-control" name="document_currency" >
                                    <option value="">--Select Currency--</option>
                                    <option value="AUD">AUD</option>
                                    <option value="INR">INR</option>
                                </select>
                                <span class="text-danger">
                                    @error('document_currency')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-5">
                                <label for="nf-email">Template Language Code</label>
                                <input class="form-control" type="text" name="template_language_code" placeholder="Enter template language code.." value="{{ old('template_language_code') }}">
                                <span class="text-danger">
                                    @error('template_language_code')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-3">
                                <label for="nf-email">Discount Type</label>
                                <select class="form-control" name="discount_type" >
                                    <option value="">--Select Discount Type--</option>
                                    <option value="percent">Percent	</option>
                                    <option value="fix">Fix</option>
                                </select>
                                <span class="text-danger">
                                    @error('discount_type')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-3">
                                <label for="nf-email">Discount Value</label>
                                <input class="form-control" type="text" name="discount_value" placeholder="Enter discount value.." value="{{ old('discount_value') }}">
                                <span class="text-danger">
                                    @error('discount_value')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button class="btn btn-sm btn-primary" type="submit"> Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
