@extends('layouts.app')
@section('title', 'Product Management')
@section('breadcrumb')
    <ol class="breadcrumb border-0 m-0 px-0 px-md-3">
        <li class="breadcrumb-item">Home</li>
        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Admin</a></li>
        <li class="breadcrumb-item"><a href="{{ route('admin.product') }}">Product Management</a></li>
        <li class="breadcrumb-item active">Add Product</li>
    </ol>
@endsection
@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">Add Product</div>
                <form class="form-horizontal" action="{{ route('admin.product.save') }}" method="post">
                    @csrf
                    <div class="card-body">

                        <div class="form-group row">
                            <div class="form-group col-sm-12">
                                <label for="nf-email">Product Name</label>
                                <input class="form-control" type="text" name="name" placeholder="Enter name.."
                                    value="{{ old('name') }}">
                                <span class="text-danger">
                                    @error('name')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-12">
                                <label for="nf-email">Comment</label>
                                <textarea class="form-control" placeholder="Enter comment.." name="comment">{{ old('comment') }}</textarea>
                                <span class="text-danger">
                                    @error('comment')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-3">
                                <label for="nf-email">Currency</label>
                                <select class="form-control" name="currency" >
                                    <option value="">--Select Currency--</option>
                                    <option value="AUD">AUD</option>
                                    <option value="INR">INR</option>
                                    {{-- @foreach ($currencyList as $key => $val )
                                        <option value="{{$val->from_currency}}" @if(old('currency')==$val->from_currency) selected @endif>{{$val->to_currency}}</option>
                                    @endforeach --}}
                                </select>
                                <span class="text-danger">
                                    @error('currency')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-3">
                                <label for="nf-email">Vat</label>   
                                <input class="form-control" type="text" name="vat" placeholder="Enter vat.."
                                    value="{{ old('vat') }}">
                                <span class="text-danger">
                                    @error('vat')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-3">
                                <label for="nf-email">Net. Unit Price</label>
                                <input class="form-control" type="text" name="net_unit_price" placeholder="Enter Net. Unit Price.."
                                    value="{{ old('net_unit_price') }}">
                                <span class="text-danger">
                                    @error('net_unit_price')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-3">
                                <label for="nf-email">Unit</label>
                                <input class="form-control" type="text" name="unit" placeholder="Enter Unit.."
                                    value="{{ old('unit') }}">
                                <span class="text-danger">
                                    @error('unit')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-5">
                                <label for="nf-email">General Ledger Number</label>
                                <input class="form-control" type="text" name="general_ledger_number" placeholder="Enter general ledger number.."
                                    value="{{ old('general_ledger_number') }}">
                                <span class="text-danger">
                                    @error('general_ledger_number')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-5">
                                <label for="nf-email">General Ledger Number Tax Code</label>
                                <input class="form-control" type="text" name="general_ledger_taxcode" placeholder="Enter general ledger tax code.."
                                    value="{{ old('general_ledger_taxcode') }}">
                                <span class="text-danger">
                                    @error('general_ledger_taxcode')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="nf-email">Entitlement</label>
                                <input class="form-control" type="text" name="entitlement" placeholder="Enter Unit.."
                                    value="{{ old('entitlement') }}">
                                <span class="text-danger">
                                    @error('entitlement')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button class="btn btn-sm btn-primary" type="submit"> Save</button>
                        <button class="btn btn-sm btn-danger" type="reset"> Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
