
<link href="{{ url('public/assets/css/style.css') }}" rel="stylesheet">

<body class="c-app flex-row align-items-center">

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card mx-4">
                    <div class="card-body p-4">
                        <form action="{{ route('register') }}" method="POST">
                            @csrf
                            <h1>Register</h1>
                            <p class="text-muted">Create your account</p>
                            <div class="input-group mt-3">
                                <div class="input-group-prepend"><span class="input-group-text">
                                        <svg class="c-icon">
                                            <use xlink:href="{{url('public/assets/vendors/@coreui/icons/svg/free.svg#cil-user') }}"></use>
                                        </svg></span></div>
                                <input class="form-control" type="text" placeholder="Username" name="name" value="{{ old('name') ?? '' }}">
                            </div>
                            <span class="text-danger">
                                @error('name')
                                    {{ $message }}
                                @enderror
                            </span>

                            <div class="input-group mt-3">
                                <div class="input-group-prepend"><span class="input-group-text">
                                        <svg class="c-icon">
                                            <use xlink:href="{{url('public/assets/vendors/@coreui/icons/svg/free.svg#cil-envelope-open') }}">
                                            </use>
                                        </svg></span></div>
                                <input class="form-control" type="text" placeholder="Email" name="email"  value="{{ old('email') ?? '' }}">
                            </div>
                            <span class="text-danger">
                                @error('email')
                                    {{ $message }}
                                @enderror
                            </span>

                            <div class="input-group mt-3">
                                <div class="input-group-prepend"><span class="input-group-text">
                                        <svg class="c-icon">
                                            <use xlink:href="{{url('public/assets/vendors/@coreui/icons/svg/free.svg#cil-phone') }}">
                                            </use>
                                        </svg></span></div>
                                <input class="form-control" type="text" placeholder="Phone" name="phone"  value="{{ old('phone') ?? '' }}">
                            </div>
                            <span class="text-danger">
                                @error('phone')
                                    {{ $message }}
                                @enderror
                            </span>

                            <div class="input-group mt-3">
                                <div class="input-group-prepend"><span class="input-group-text">
                                        <svg class="c-icon">
                                            <use xlink:href="{{url('public/assets/vendors/@coreui/icons/svg/free.svg#cil-calendar') }}">
                                            </use>
                                        </svg></span></div>
                                <input class="form-control" type="date" placeholder="Date of Birth" name="date"  value="{{ old('date') ?? '' }}">
                            </div>
                            <span class="text-danger">
                                @error('date')
                                    {{ $message }}
                                @enderror
                            </span>

                            <div class="input-group mt-3">
                                <div class="input-group-prepend"><span class="input-group-text">
                                        <svg class="c-icon">
                                            <use xlink:href="{{url('public/assets/vendors/@coreui/icons/svg/free.svg#cil-lock-locked') }}"></use>
                                        </svg></span></div>
                                <input class="form-control" type="password" placeholder="Password" name="password">
                            </div>
                            <span class="text-danger">
                                @error('password')
                                    {{ $message }}
                                @enderror
                            </span>

                            <div class="input-group mt-3">
                                <div class="input-group-prepend"><span class="input-group-text">
                                        <svg class="c-icon">
                                            <use xlink:href="{{url('public/assets/vendors/@coreui/icons/svg/free.svg#cil-lock-locked') }}"></use>
                                        </svg></span></div>
                                <input class="form-control" type="password" placeholder="Repeat password"
                                    name="password_confirmation">
                            </div>
                            <span class="text-danger">
                                @error('password_confirmation')
                                    {{ $message }}
                                @enderror
                            </span>

                            <button class="btn btn-block btn-success mt-4" type="submit">Create Account</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- CoreUI and necessary plugins-->
    <script src="{{ url('public/assets/vendors/@coreui/coreui-pro/js/coreui.bundle.min.js') }}"></script>
    <!--[if IE]><!-->
    <script src="{{ url('public/assets/vendors/@coreui/icons/js/svgxuse.min.js') }}"></script>
    <!--<![endif]-->
    <script>
        document.addEventListener("DOMContentLoaded", function(event) {
            setTimeout(function() {
                document.body.classList.remove('c-no-layout-transition')
            }, 2000);
        });
    </script>
</body>
