@extends('layouts.app')
@section('title', 'Role Management')
@section('breadcrumb')
    <ol class="breadcrumb border-0 m-0 px-0 px-md-3">
        <li class="breadcrumb-item">Home</li>
        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Admin</a></li>
        <li class="breadcrumb-item"><a href="{{ route('admin.role') }}">Role Management</a></li>
        <li class="breadcrumb-item active">Edit Role</li>
    </ol>
@endsection
@section('content')
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">Edit Role</div>
            <form class="form-horizontal" action="{{ route('admin.role.update') }}" method="post">
                @csrf
                <input type="hidden" name="role_id" value="{{ $role->id }}" >
                <div class="card-body">
                    <div class="form-group row">
                        <div class="form-group col-sm-3">
                            <label for="nf-email">Role Name</label>
                            <input class="form-control" type="text" name="name" placeholder="Enter name.." value="{{ old('name') ? old('name') : $role->name }}" >
                            <span class="text-danger">
                                @error('name')
                                    {{ $message }}
                                @enderror
                            </span>
                        </div>
                        <div class="form-group col-sm-9">
                            <label for="nf-email">Role Description</label>
                            <input class="form-control" type="text" name="description" placeholder="Enter description.." value="{{ old('description') ? old('description') : $role->description }}">
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button class="btn btn-sm btn-primary" type="submit"> Update </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
