@extends('layouts.app')
@section('css')
    {{-- css --}}
    <link href="{{ url('public/assets/vendors/datatables.net-bs4/css/dataTables.bootstrap4.css') }}" rel="stylesheet">
    <style>
        div.dataTables_wrapper div.dataTables_length select { width: 60px }
        #DataTables_Table_0_wrapper .col-sm-12 { overflow: auto; }
    </style>
@endsection
@section('title', 'Spendings Management')
@section('breadcrumb')
    <ol class="breadcrumb border-0 m-0 px-0 px-md-3">
        <li class="breadcrumb-item">Home</li>
        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Admin</a></li>
        <li class="breadcrumb-item active">Spendings Management</li>
    </ol>
@endsection
@section('content')
    <div class="card">
        <div class="card-header"> Spendings Management
            <div class="card-header-actions">
                <a href="{{ route('admin.add.spendings') }}" class="btn btn-square btn-block btn-info">+ Create Spendings</a>
            </div>
        </div>
        <div class="card-body">
            @if(Session::has('success_msg')) <div class="alert alert-success" role="alert">{{ Session::get('success_msg') }}</div> @endif
            @if(Session::has('error_msg')) <div class="alert alert-danger" role="alert">{{ Session::get('error_msg') }}</div> @endif
            <table class="table table-striped table-bordered datatable">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Invoice Number</th>
                        <th>Due Date</th>
                        <th>Category</th>
                        <th>Comment</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                        <tr>
                            <td>Date</td>
                            <td>Invoice Number</td>
                            <td>Due Date</td>
                            <td>Category</td>
                            <td>Comment</td>
                            <td>
                                <a class="btn btn-info mr-1" href="{{ route('admin.edit.spendings',1) }}">
                                    <svg class="c-icon">
                                        <use xlink:href="{{ url('public/assets/vendors/@coreui/icons/svg/free.svg#cil-pencil') }}"></use>
                                    </svg>
                                </a>
                                <a class="btn btn-danger mr-1" href="{{ route('admin.delete.spendings',1) }}" onclick="return confirm('Are you sure you want to delete this spendings?');">
                                    <svg class="c-icon">
                                        <use xlink:href="{{ url('public/assets/vendors/@coreui/icons/svg/free.svg#cil-trash') }}"></use>
                                    </svg>
                                </a>
                            </td>
                        </tr>
                </tbody>
            </table>
        </div>
    </div>
@endsection

@section('js')
    {{-- js --}}
    <script src="{{ url('public/assets/vendors/jquery/js/jquery.slim.min.js') }}"></script>
    <script src="{{ url('public/assets/vendors/datatables.net/js/jquery.dataTables.js') }}"></script>
    <script src="{{ url('public/assets/vendors/datatables.net-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ url('public/assets/js/datatables.js') }}"></script>
    {{--End js --}}
@endsection
