@extends('layouts.app')
@section('title', 'User Management')
@section('breadcrumb')
    <ol class="breadcrumb border-0 m-0 px-0 px-md-3">
        <li class="breadcrumb-item">Home</li>
        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Admin</a></li>
        <li class="breadcrumb-item"><a href="{{ route('admin.user') }}">User Management</a></li>
        <li class="breadcrumb-item active">Edit User</li>
    </ol>
@endsection
@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">Edit User</div>
                <form class="form-horizontal" action="{{ route('admin.user.update') }}" method="post">
                    @csrf
                    <input type="hidden" name="user_id" value="{{ $user->id }}" >
                    <div class="card-body">

                        <div class="form-group row">
                            <div class="form-group col-sm-8">
                                <label for="nf-email">User Name</label>
                                <input class="form-control" type="text" name="name" placeholder="Enter name.."
                                    value="{{ old('name') ? old('name') : $user->name  }}">
                                <span class="text-danger">
                                    @error('name')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="nf-email">User Role</label>
                                <select class="form-control" name="role_id" >
                                    <option value="">--Select Role--</option>
                                    @foreach ($roles as $key => $val )
                                        <option value="{{$val->id}}" @if((old('role_id') ? old('role_id') : ($user->roles[0]->id ?? ''))==$val->id) selected @endif>{{$val->name}}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger">
                                    @error('role_id')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="nf-email">Email</label>
                                <input class="form-control" type="text" name="email" placeholder="Enter email.." value="{{ old('email') ? old('email') : $user->email }}">
                                <span class="text-danger">
                                    @error('email')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="nf-email">Phone Number</label>
                                <input class="form-control" type="text" name="phone" placeholder="Enter phone number.." value="{{ old('phone') ? old('phone') : $user->phone }}">
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="nf-email">D.O.B.</label>
                                <input class="form-control" type="date" name="dob"  value="{{ old('dob') ? old('dob') : $user->dob }}">
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button class="btn btn-sm btn-primary" type="submit"> Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
