<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\IndexController;
use App\Http\Controllers\Admin\AccountController;
use App\Http\Controllers\Admin\CustomerController;

use App\Http\Controllers\Admin\PartnerController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\SpendingsController;
use App\Http\Controllers\Admin\UserController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });
// dashboard management
Route::get('/', function () {return view('admin.auth.login'); });

// login management
Route::get('/login', function () { if(Session::has('login_user')){ return redirect('dashboard'); } return view('admin.auth.login'); })->name('login');
Route::post('/login',[UserController::class,'login'])->name('login');

// logout management
Route::get('/logout',[UserController::class,'logout'])->name('logout');

// register management
Route::get('/register', function () { if(Session::has('login_user')){ return redirect('dashboard'); }  return view('admin.auth.register'); })->name('register');
Route::post('/register',[UserController::class,'register'])->name('register');


// forgot-password management
Route::get('/forgot-password', function () { if(Session::has('login_user')){ return redirect('dashboard'); }  return view('admin.auth.forgot-password'); })->name('forgot-password');
Route::post('/forgot-password',[UserController::class,'forgot_password'])->name('forgot-password');
Route::get('/email-verification', function () { if(Session::has('login_user')){ return redirect('dashboard'); }  return view('admin.auth.email-verification'); })->name('email-verification');
Route::post('/email-verification',[UserController::class,'email_verification'])->name('email-verification');
Route::get('dashboard',[IndexController::class,'index'])->name('admin.dashboard');

// role management
Route::get('role',[UserController::class,'role'])->name('admin.role');
Route::get('add-role',[UserController::class,'add_role'])->name('admin.add.role');
Route::get('edit-role/{id}',[UserController::class,'edit_role'])->name('admin.edit.role');
Route::get('delete-role/{id}',[UserController::class,'delete_role'])->name('admin.delete.role');
Route::post('save_role',[UserController::class,'save_role'])->name('admin.role.save');
Route::post('update_role',[UserController::class,'update_role'])->name('admin.role.update');

// user management
Route::get('user',[UserController::class,'user'])->name('admin.user'); 
Route::get('add-user',[UserController::class,'add_user'])->name('admin.add.user');
Route::get('edit-user/{id}',[UserController::class,'edit_user'])->name('admin.edit.user');
Route::get('delete-user/{id}',[UserController::class,'delete_user'])->name('admin.delete.user');
Route::post('save_user',[UserController::class,'save_user'])->name('admin.user.save');
Route::post('update_user',[UserController::class,'update_user'])->name('admin.user.update');

// customer Management 
Route::get('customer',[CustomerController::class,'customerList'])->name('admin.customer');
Route::get('add-customer',[CustomerController::class,'addCustomer'])->name('admin.add.customer');

// Account Management 
Route::get('account',[AccountController::class,'account'])->name('admin.account');
Route::get('information',[AccountController::class,'information'])->name('admin.information.account');
Route::get('photoGallery',[AccountController::class,'photoGallery'])->name('admin.photoGallery.account');
Route::get('activeServices',[AccountController::class,'activeServices'])->name('admin.activeServices.account');
Route::get('addInternetService',[AccountController::class,'addInternetService'])->name('admin.addInternetService.account');
Route::get('addservice',[AccountController::class,'addservice']);
Route::get('service',[AccountController::class,'service']);
Route::get('editservice',[AccountController::class,'editservice']);

Route::get('createnewcontract',[AccountController::class,'createnewcontract']);

Route::get('iptv',[AccountController::class,'iptv']);
Route::get('service_edit',[AccountController::class,'Serviceedit']);
Route::get('catv',[AccountController::class,'catv']);
Route::get('dvbc',[AccountController::class,'dvbc']);
Route::get('volp',[AccountController::class,'volp']);
Route::get('pdf',[AccountController::class,'pdf']);
Route::get('moblie',[AccountController::class,'moblie']);
Route::get('mail',[AccountController::class,'Mail']);
Route::get('statistics-ip-ranges',[AccountController::class,'ip_ranges']);
Route::get('contracts',[AccountController::class,'contract']);
Route::get('cancellation',[AccountController::class,'cancellation']);
Route::get('Documents',[AccountController::class,'Documents']);
Route::get('ipaddress',[AccountController::class,'OtherIP']);
Route::get('datatransfer',[AccountController::class,'Datatransfer']);
Route::get('subordinate',[AccountController::class,'Subordinate']);
Route::get('clientmonitoring',[AccountController::class,'Clientmonitoring']);
Route::get('transferservices',[AccountController::class,'Transferservices']);
Route::get('internetstatistics',[AccountController::class,'Internetstatistics']);

Route::get('clientinfo',[AccountController::class,'Clientinfo']);


// partner management
Route::get('partner',[PartnerController::class,'partner'])->name('admin.partner'); 
Route::get('add-partner',[PartnerController::class,'add_partner'])->name('admin.add.partner');
Route::get('edit-partner/{id}',[PartnerController::class,'edit_partner'])->name('admin.edit.partner');
Route::get('delete-partner/{id}',[PartnerController::class,'delete_partner'])->name('admin.delete.partner');
Route::post('save_partner',[PartnerController::class,'save_partner'])->name('admin.partner.save');
Route::post('update_partner',[PartnerController::class,'update_partner'])->name('admin.partner.update');


// Spendings management
Route::get('spendings',[SpendingsController::class,'spendings'])->name('admin.spendings'); 
Route::get('add-spendings',[SpendingsController::class,'add_spendings'])->name('admin.add.spendings');
Route::get('edit-spendings/{id}',[SpendingsController::class,'edit_spendings'])->name('admin.edit.spendings');
Route::get('delete-spendings/{id}',[SpendingsController::class,'delete_spendings'])->name('admin.delete.spendings');
Route::post('save_spendings',[SpendingsController::class,'save_spendings'])->name('admin.spendings.save');
Route::post('update_spendings',[SpendingsController::class,'update_spendings'])->name('admin.spendings.update');

// product management
Route::get('product',[ProductController::class,'product'])->name('admin.product'); 
Route::get('add-product',[ProductController::class,'add_product'])->name('admin.add.product');
Route::get('edit-product/{id}',[ProductController::class,'edit_product'])->name('admin.edit.product');
Route::get('delete-product/{id}',[ProductController::class,'delete_product'])->name('admin.delete.product');
Route::post('save_product',[ProductController::class,'save_product'])->name('admin.product.save');
Route::post('update_product',[ProductController::class,'update_product'])->name('admin.product.update');


// Setting Bank Account
Route::get('bank-account',[SettingController::class,'bank_account'])->name('admin.bank.account'); 
Route::get('add-bank-account',[SettingController::class,'add_bank_account'])->name('admin.add.bank.account');
Route::get('edit-bank-account/{id}',[SettingController::class,'edit_bank_account'])->name('admin.edit.bank.account');
Route::get('delete-bank-account/{id}',[SettingController::class,'delete_bank_account'])->name('admin.delete.bank.account');
Route::post('save_bank-account',[SettingController::class,'save_bank_account'])->name('admin.bank.account.save');
Route::post('update_bank-account',[SettingController::class,'update_bank_account'])->name('admin.bank.account.update');